
/*****************************************************************************
*
*  Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

/*!*********************************************************************************
*  @file    orbfast9_graph.hpp
*  @brief   ACF graph
***********************************************************************************/

#ifndef ORBFAST9GRAPH_HPP
#define ORBFAST9GRAPH_HPP

#include <acf_graph.hpp>

#ifdef APEX2_EMULATE
#include "acf_lib.hpp"
using namespace APEX2;
#endif

#include "orbfast9_graph_names.h"

#include "fast9_acf.h"
#include "gauss_3x3_acf.h"
#include "nms_acf.h"

class OrbFast9Graph: public ACF_Graph
{
public:
  OrbFast9Graph() : ACF_Graph()
  {
    XREGISTER_ACF_KERNEL(GAUSS_3x3_K);
    XREGISTER_ACF_KERNEL(FAST9_K);
    XREGISTER_ACF_KERNEL(NMS_K);
  }

  void Create()
  {
    //set identifier for graph
    SetIdentifier("OrbFast9Graph");

    //add kernels
    const std::string gauss_3x3_0("gauss_3x3_0");
    AddKernel(gauss_3x3_0, GAUSS_3x3_KN);
    const std::string fast9_0("fast9_0");
    AddKernel(fast9_0, FAST9_KN);
    const std::string nms_0("nms_0");
    AddKernel(nms_0, NMS_KN);

    //add graph ports
    AddInputPort(GR_INPUTIMG_IN);
    AddInputPort(GR_INPUTTHR_IN);
    AddOutputPort(GR_OUTPUT0_OUT);
    AddOutputPort(GR_OUTPUT1_OUT);

    //specify connections
    Connect(GraphPort(GR_INPUTIMG_IN), KernelPort(gauss_3x3_0, GAUSS_3x3_KN_IN));
    Connect(GraphPort(GR_INPUTTHR_IN), KernelPort(fast9_0, FAST9_KN_IN_THR));
    Connect(KernelPort(gauss_3x3_0, GAUSS_3x3_KN_OUT), KernelPort(fast9_0, FAST9_KN_IN_IMG));
    Connect(KernelPort(fast9_0, FAST9_KN_OUT), KernelPort(nms_0, NMS16_KN_IN));
    Connect(KernelPort(nms_0, NMS16_KN_OUT), GraphPort(GR_OUTPUT0_OUT));
    Connect(KernelPort(gauss_3x3_0, GAUSS_3x3_KN_OUT), GraphPort(GR_OUTPUT1_OUT));
  }
};

#endif /* ORBFAST9GRAPH_HPP */
